#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Bouncing OrbMod01.fsh   by  QuantumSuper  
//https://www.shadertoy.com/view/DtXSR8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Bouncing Orb v0.91-220120
// Simple distance-aided ray marching with floor and spheres.
// Inspired by The Art of Code's ray marching tutorial: youtu.be/PGtv-dBi2wE

// DEFINITIONS
// Calculation precision
#define MAX_STEPS 70
#define MAX_DISTANCE 110.0
#define MIN_DISTANCE 0.01

// Global objects, lights & cam initializations
struct object{
	int type; //0: floor; 1: sphere
	vec4 param; //horizontal plane: y, y, y, y; sphere: x, y, z, radius
};
object[4] objects; // ...is there a better way to get iterability of different objects?
struct light{ //spotlights
	vec3 pos; //x,y,z; position of light
	vec3 col; //(r,g,b)*amp; color & brightness of light
};
light[2] lights;
float[2] animTime; //time for object operations
float camTime; //time for camera operations

// FUNCTIONS
// Calculate distance from position p to next object
float getDistance(vec3 pos){	
	float minDist = MAX_DISTANCE; //max minDist
	
	for (int n=0; n<objects.length(); n++){ //get the distance to each object
		switch (objects[n].type){
			case 0: //hPlane
				//minDist = min(minDist, pos.y-objects[n].param.y); break; //hPlane static
                minDist = min(minDist, pos.y-objects[n].param.y+0.2*sin(animTime[1])*sin(4.0*animTime[0]-length(pos)/0.2)*smoothstep(22.*clamp(0.9+cos(animTime[1]),0.,2.),-0.1,pos.x*pos.x+pos.z*pos.z)); break; //hPlane flubber, ?BUG for long iTime: pattern breaks
			case 1: //sphere
				minDist = min(minDist, length(pos-objects[n].param.xyz)-objects[n].param.w); break;
			case 2: //flubber sphere
				minDist = min(minDist, length(pos-objects[n].param.xyz)-objects[n].param.w+0.1*cos(animTime[1])*smoothstep(-0.2,1.2,abs(cos(pos.x*pos.y*pos.z)))); break;
		}
	}
	
	return minDist;
}

// March the ray through tracing spheres
float rayMarch(vec3 rayOrigin, vec3 rayDirection){
	float rayLength = MIN_DISTANCE; 
	float radSphere;
	
	for (int n=0; n<MAX_STEPS; n++){
		radSphere = getDistance(rayOrigin+rayLength*rayDirection); //get sphere
		rayLength += radSphere; //march
		if (rayLength>MAX_DISTANCE || abs(radSphere)<MIN_DISTANCE) break;
	}
	
	return rayLength;
}

// Estimate the surface normal at position p
vec3 guessNormal(vec3 pos){
	vec2 tangent = vec2(MIN_DISTANCE, 0);
	
	vec3 normal = getDistance(pos) - vec3(
		getDistance(pos-tangent.xyy),
		getDistance(pos-tangent.yxy), 
		getDistance(pos-tangent.yyx)
		);
		
	return normalize(normal);
}

// Calculate light diffusion
vec3 getSpotlight(vec3 pos, light myLight){
	vec3 lightDirection = normalize(myLight.pos - pos);
	vec3 surfaceNormal = guessNormal(pos);
	
	float diffLight = clamp(dot(lightDirection, surfaceNormal), 0.0, 1.0); //intensity
    diffLight = pow(diffLight,3.)*1.5; //?fake shine
	if (rayMarch(pos + 2.0*MIN_DISTANCE*surfaceNormal, lightDirection) < length(myLight.pos-pos)) diffLight *= 0.2; //shadows at 20%
	return myLight.col*vec3(diffLight); //color 
}

// MAIN

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	// Misc initialization
    vec3 col = vec3(0); //fragColor
	vec2 uv = (2.*fragCoord-iResolution.xy) / max(iResolution.x, iResolution.y); //normalized true-scaling pixel uv mapping, longer edge square -1..1
    float myDist; // ray length
	animTime = float[]( //time for object operations
		mod(2.133333*iTime, 6.283185), //std, mod 2pi because of ?overflow: bug at getDistance case 0 if not mod
		mod(0.2666666*iTime, 6.283185) //slow
	);
    
    // Camera initialization
    vec3 camPos = vec3(0, 2.5, 0); //ray origin, static
	//vec3 camDir = normalize(vec3(uv.x, uv.y, 1)); //ray direction, static straight
	vec3 camDir = normalize(vec3(uv.x, uv.y*cos(.15)-sin(.1), uv.y*sin(.15)+cos(.1))); //ray direction, static, slightly downwards
	camTime = 0.2*iTime; //time for cam operations
	camPos += vec3(9.*sin(camTime), 0,-9.*cos(camTime)); //rotating on circle
    camDir = vec3( //rotation on xz-plane about (0,0,0)
		camDir.x*cos(camTime)-camDir.z*sin(camTime),
		camDir.y,
		camDir.x*sin(camTime)+camDir.z*cos(camTime)
	);
	
	// Object initializations
	objects = object[](
		object(0, vec4(0)), //hPlane
		object(2, vec4(0,2.9,0,2.0+cos(animTime[1]))), //sphere 1, shrink & grow
        object(1, vec4(-3,0.4+3.*abs(sin(animTime[0])),5,0.5)), //sphere 2, bounce up & down
		object(1, vec4(3,0.4+3.*abs(cos(1.5*animTime[0])),-5,0.5)) //sphere 3, bounce up & down
	);
	
	// Spotlight initialization
    lights = light[]( //light pos, light col
		light(vec3(9.*cos(camTime+.1), 3.5, 9.*sin(camTime+.1)), //cam syncronized rotation
			normalize(vec3(245.*(1.+0.7*cos(animTime[1])),10,193))*1.5), // synthwave pink, dynamic
		light(vec3(8.*sin(camTime-0.4), 4.5, 8.*-cos(camTime-0.4)), //cam syncronized rotation
			normalize(vec3(73,10,245))*0.1) //synthwave blue
	);
	
	// Calculate depth-map
	myDist = rayMarch(camPos, camDir);
	
	// Calculate diffused spotlight & convert to color
	for (int n=0; n<lights.length(); n++){
		col += getSpotlight(camPos+myDist*camDir, lights[n]);
	}
	col = pow(col, vec3(.4545)); //gamma correction
	
	fragColor = vec4(col, 1.0); //output

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

